#!/usr/bin/python

# Argumets:
# 1) text file with indices of measured chunks
# 2) length of chunk
# 3) p0
# 4) p1
# 5) full grid size
# 6) Algorithm (IST/IRLS)
# 7) Number of iterations
# 8) Virtual echo (y/n)

# ./1D_bruker_nused_chunks.py nuslist 100 131 15 6400 IST 300 y

from numpy import *
import nmrglue as ng
import sys
import os
import struct

print "\nReading data...",
dic, data = ng.fileio.bruker.read(dir='.',bin_file='fid')
print "done!\n"

### Schedule for MDD
print "\nPhasing and reading sampling scheme...",
nuslist = loadtxt(sys.argv[1]) 
nuslist = nuslist.astype(int)
length = int(sys.argv[2])

nl_ind = argsort(nuslist)
nuslist = sort(nuslist)
data_s = zeros(shape(data), dtype=complex)
for i in range(len(nl_ind)):
    c = nl_ind[i]
    data_s[i*length:(i+1)*length] = data[c*length:(c+1)*length]
data = data_s

sched = []
for i in range(len(nuslist)):
    sched = hstack([sched, nuslist[i]*length + arange(length)])
ind = sched.astype(int)
I = len(ind)

p0=float(sys.argv[3])
p0=p0*pi/180
data = data*exp(p0*1j)
p1=float(sys.argv[4])
p1=p1*pi/180 
data = fft.fft(data)
D = int(sys.argv[5]) # full grid size
data = data*exp(1j*ind*p1/D) #
data = fft.ifft(data)

k = 0
ind_alternated = zeros(2*I)
for i in range(I):
    ind_alternated[k] = 2*ind[i]
    ind_alternated[k + 1] = ind_alternated[k] + 1
    k = k + 2
ind_alternated = ind_alternated.astype(int)
print "done!\n"

### FID for MDD
print "\nPreparing .mdd file...",
fid = data
fid_alternated = empty(2*len(fid))
fid_alternated[0::2] = real(fid)
fid_alternated[1::2] = imag(fid)

### Writing to file .MDD
regions = 1
dimensions = 2

line1 = str(dimensions) + ' 1 ' + str(regions*2*I) + '\n'
line2 = str(regions) + ' ' + str(2*D)
s = ''
for i in range(2*I):
    s = s + '\n' + str(0) + ' ' + str(ind_alternated[i])
f = ''
for i in range(2*I):
    f = f + '\n' + str(fid_alternated[i])
contents = 'mdd asc sparse f180.0 \n ./MDD/region01.mdd \n MDD sparse\n $ \n' + line1 + line2 + s + f # contains the data to be written to .mdd file

folder = os.getcwd() + '/MDD/' 
if not os.path.exists(folder):
    os.makedirs(folder)
os.chdir(folder)
file = open('region01.mdd', 'w')
file.write(contents)
file.close()
print "done!\n"

print "\nReconstructing gaps..."
os.system("tcsh -c  'cssolver region01 CS_alg="+sys.argv[6]+" CS_niter="+sys.argv[7]+" CS_VE="+sys.argv[8]+" CS_ZF=2 MDD_NOISE=1 > region01.log'") # executes .mdd file
print "done!\n"

### Reading .CS file
print "\nMaking fid_rec file...",
file = open('region01.cs', 'rb')
cs = empty(2*D)
for i in range(2*D):
    cs[i] = float(struct.unpack('f', file.read(4))[0])
file.close()
fid_rec = cs[0::2] + 1j*cs[1::2] # to be written to "fid" file

### Wrinting to .FID file
os.chdir("..")
ng.fileio.bruker.write(os.getcwd(), dic, fid_rec, bin_file='fid_rec', overwrite=True)
print "done!\n"
